/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import reliquary.crafting.AlkahestryChargingRecipe;
import reliquary.crafting.AlkahestryCraftingRecipe;
import reliquary.crafting.AlkahestryDrainRecipe;

public class AlkahestryRecipeRegistry {
    @Nullable
    private static AlkahestryDrainRecipe drainRecipe = null;
    private static final Map<ResourceLocation, AlkahestryCraftingRecipe> craftingRecipes = new LinkedHashMap<ResourceLocation, AlkahestryCraftingRecipe>();
    private static final Map<ResourceLocation, AlkahestryChargingRecipe> chargingRecipes = new LinkedHashMap<ResourceLocation, AlkahestryChargingRecipe>();

    private AlkahestryRecipeRegistry() {
    }

    static void setDrainRecipe(AlkahestryDrainRecipe drainRecipe) {
        AlkahestryRecipeRegistry.drainRecipe = drainRecipe;
    }

    public static Optional<AlkahestryDrainRecipe> getDrainRecipe() {
        return Optional.ofNullable(drainRecipe);
    }

    public static Collection<AlkahestryCraftingRecipe> getCraftingRecipes() {
        return craftingRecipes.values();
    }

    static void registerCraftingRecipe(AlkahestryCraftingRecipe alkahestryCraftingRecipe) {
        craftingRecipes.put(alkahestryCraftingRecipe.m_6423_(), alkahestryCraftingRecipe);
    }

    static void registerChargingRecipe(AlkahestryChargingRecipe alkahestryChargingRecipe) {
        chargingRecipes.put(alkahestryChargingRecipe.m_6423_(), alkahestryChargingRecipe);
    }

    public static Collection<AlkahestryChargingRecipe> getChargingRecipes() {
        return chargingRecipes.values();
    }

    public static void onResourceReload(AddReloadListenerEvent event) {
        drainRecipe = null;
        craftingRecipes.clear();
        chargingRecipes.clear();
    }
}

